/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagespawnpoint.events;

import com.natamus.collective.functions.BlockPosFunctions;
import com.natamus.collective.functions.FeatureFunctions;
import com.natamus.collective.functions.WorldFunctions;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.settings.DimensionGeneratorSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class VillageSpawnEvent {
    @SubscribeEvent
    public void onWorldLoad(WorldEvent.CreateSpawnPosition e) {
        World world = WorldFunctions.getWorldIfInstanceOfAndNotRemote((IWorld)e.getWorld());
        if (world == null) {
            return;
        }
        if (!(world instanceof ServerWorld)) {
            return;
        }
        ServerWorld serverworld = (ServerWorld)world;
        DimensionGeneratorSettings generatorsettings = serverworld.func_73046_m().func_240793_aU_().func_230418_z_();
        if (!generatorsettings.func_236222_c_()) {
            return;
        }
        BlockPos spawnpos = BlockPosFunctions.getCenterNearbyVillage((ServerWorld)serverworld);
        if (spawnpos == null) {
            return;
        }
        e.setCanceled(true);
        serverworld.func_241124_a__(spawnpos, 1.0f);
        if (generatorsettings.func_236223_d_()) {
            FeatureFunctions.placeBonusChest((World)serverworld, (BlockPos)spawnpos);
        }
    }
}

